#### representative bayou analysis

library(bayou)
library(caper)
require(devtools)
require(geiger)
library(knitr)
library(adephylo)
library(parallel)
library(doParallel)

analysis.name<-"isler.fossil.graft.no.ardi"
dependent.var<- "Log.ECV"
independent.var<-"Log.Body.Mass.female"
Formula<-Log.ECV ~ Log.Body.Mass.female

tree = read.nexus("hominin.phylogeny.txt")
data = read.csv("data set 1.csv", header=T)
data[,1]<-gsub(" ","_",data[,1])

### prep data
yname<- dependent.var
y=which(colnames(data)==yname)  #column name of dependent variable
zname<-  independent.var
z=which(colnames(data)==zname)  #column name of independent variable

###remove NAs
if (sum(is.na(data[,y]))>0) {data<-data[-c(which(is.na(data[,y]))),]}
if (sum(is.na(data[,z]))>0) {data<-data[-c(which(is.na(data[,z]))),]}

###get rid of tips that don't correspond to data
subtree<-c()
for (i in 1:length(tree$tip.label)) {if (! tree$tip.label[i] %in% data[,1]) {subtree<-c(subtree,i)}}
tree<-drop.tip(tree,subtree)
if (is.binary.tree(tree) != T) {tree<-multi2di(tree)}
zero.branches<-which(tree$edge.length==0)
tree$edge.length[zero.branches]<-rep(.0001,times=length(zero.branches))

##get rid of data that isn't in tree
drop.dat<-which(! (data[,1] %in% tree$tip.label))
data<-data[-c(drop.dat),]
###set order of data to order of tips
newdata<-matrix(NA,dim(data)[1],3)
colnames(newdata)<-c("species",yname,zname)
a<-c(match(tree$tip.label,as.vector(data[,1])))
for (i in 1:dim(newdata)[1])
{
  newdata[i,1]<-paste(data[a[i],1])
  newdata[i,2]<-as.numeric(data[a[i],y])
  newdata[i,3]<-as.numeric(data[a[i],z])
}
a<-as.numeric(newdata[,2])
b<-as.numeric(newdata[,3])
newdata<-as.data.frame(newdata) 
newdata[,2]<-a
newdata[,3]<-b

### Make Vectors
dat<-as.vector(as.numeric(newdata[,2]))
pred<-as.vector(as.numeric(newdata[,3]))
names(dat)<-newdata[,1]
names(pred)<-newdata[,1]
pred<-cbind(pred)
colnames(pred)<-"pred1"

regres.data<-as.data.frame(cbind(dat,pred))
regression<-lm(dat~pred,data=regres.data)

### make prior
prior.OU <- make.prior(tree, plot.prior = TRUE, 
                       dists=list(dalpha="dhalfcauchy", dsig2="dhalfcauchy", dbeta_pred1="dnorm",
                                  dsb="dsb", dk="cdpois", dtheta="dnorm"), 
                       param=list(dalpha=list(scale=1), dsb=list(bmax=1,prob=1),dsig2=list(scale=0.1),
                                  dbeta_pred1=list(mean=regression$coefficients[2], sd=.5),
                                  dk=list(lambda=.1*(length(tree$edge.length)), kmax=2*(length(tree$edge.length))-2), 
                                  dtheta=list(mean=regression$coefficients[1], sd=1)))

prior.BM<- make.prior(tree, plot.prior=TRUE,
                      dists=list(dalpha="fixed", dsig2="dhalfcauchy",dbeta_pred1="dnorm", dsb="fixed", dk="fixed", dloc="fixed"),
                      param=list(dsig2=list(scale=.1),dbeta_pred1=list(mean=regression$coefficients[2], sd=.5), dtheta=list(mean=regression$coefficients[1], sd=1)),
                      fixed=list(alpha=0, k=0, loc=numeric(0), t2=numeric(0),sb=numeric(0)))



startpars.OU = list(alpha=2, sig2=2, beta_pred=regression$coefficients[2], k=c(1,1), theta=regression$coefficients[1], slide=1)
startpars.BM<-list(alpha=0,sig2=2,k=0,ntheta=1,theta=regression$coefficients[1],sb=numeric(0),loc=numeric(0),t2=numeric(0),beta_pred1=regression$coefficients[[2]])

SE=c(rep(0,times=length(dat)))

model.OU.1 <- makeBayouModel(dat ~ pred1, rjpars = c("theta", "pred1"),tree, dat, pred,prior.OU,startpar =startpars.OU,SE=0,impute=NULL,slopechange = "immediate") #no beta weighting
model.OU.2 <- makeBayouModel(dat ~ pred1, rjpars = c("theta", "pred1"),tree, dat, pred,prior.OU, startpar =startpars.OU,SE=0,impute=NULL,slopechange = "alphaWeighted") #beta weighting
model.BM <- makeBayouModel(dat ~ pred1, rjpars = c("theta", "pred1"),tree, dat, pred,prior.BM, startpar =startpars.BM,SE=0,impute=NULL,slopechange = "immediate") #beta weighting

ngen<-5005000
samp<-10

mcmc.OU.1.1 <-  bayou.makeMCMC(tree, dat, pred=pred, SE=0, model=model.OU.1$model, prior=prior.OU)
mcmc.OU.1.1$run(ngen)
OU.1chain1<-mcmc.OU.1.1$load()
saveRDS(OU.1chain1,file="OU.1chain1")
OU.1chain1<-readRDS(file="OU.1chain1")

closeAllConnections() 

mcmc.OU.1.2 <-  bayou.makeMCMC(tree, dat, pred=pred, SE=0, model=model.OU.1$model, prior=prior.OU)
mcmc.OU.1.2$run(ngen)
OU.1chain2<-mcmc.OU.1.2$load()
saveRDS(OU.1chain2,file="OU.1chain2")
OU.1chain2<-readRDS(file="OU.1chain2")

closeAllConnections() 

mcmc.OU.2.1 <-  bayou.makeMCMC(tree, dat, pred=pred, SE=0, model=model.OU.2$model, prior=prior.OU)
mcmc.OU.2.1$run(ngen)
OU.2chain1<-mcmc.OU.2.1$load()
saveRDS(OU.2chain1,file="OU.2chain1")
OU.2chain1<-readRDS(file="OU.2chain1")

closeAllConnections() 

mcmc.OU.2.2 <-  bayou.makeMCMC(tree, dat, pred=pred, SE=0, model=model.OU.2$model, prior=prior.OU)
mcmc.OU.2.2$run(ngen)
OU.2chain2<-mcmc.OU.2.2$load()
saveRDS(OU.2chain2,file="OU.2chain2")
OU.2chain2<-readRDS(file="OU.2chain2")

closeAllConnections() 

mcmc.BM.1<-  bayou.makeMCMC(tree, dat, pred=pred, SE=0, model=model.BM$model, prior=prior.BM,startpar = startpars.BM,plot.freq = NULL)
mcmc.BM.1$run(ngen)
BM.chain1<-mcmc.BM.1$load()
saveRDS(BM.chain1,file="BM.chain1")
BM.chain1<-readRDS(file="BM.chain1")

closeAllConnections() 

mcmc.BM.2<-  bayou.makeMCMC(tree, dat, pred=pred, SE=0, model=model.BM$model, prior=prior.BM,startpar = startpars.BM,plot.freq = NULL)
mcmc.BM.2$run(ngen)
BM.chain2<-mcmc.BM.2$load()
saveRDS(BM.chain2,file="BM.chain2")
BM.chain2<-readRDS(file="BM.chain2")

#make combined chains
OUchains <- combine.chains(list(OU.1chain1, OU.1chain2), burnin.prop=0.3)
attributes(OUchains)$tree <- tree
attributes(OUchains)$dat <- dat

OUchains.alpha.weighted <- combine.chains(list(OU.2chain1, OU.2chain2), burnin.prop=0.3)
attributes(OUchains.alpha.weighted)$tree <- tree
attributes(OUchains.alpha.weighted)$dat <- dat

BMchains <- combine.chains(list(BM.chain1, BM.chain2), burnin.prop=0.3)
attributes(BMchains)$tree <- tree
attributes(BMchains)$dat <- dat

OUchains <- combine.chains(list(OU.1chain1, OU.1chain2), burnin.prop=0.3)
attributes(OUchains)$tree <- tree
attributes(OUchains)$dat <- dat


#### model selection

Bk <- qbeta(seq(0,1, length.out=5), 0.3,1)
set.seed(1)
bayes.factors<-matrix(NA,3,3)
name.vec<-c("OU","OU alpha weighted","BM")
rownames(bayes.factors)<-name.vec
colnames(bayes.factors)<-name.vec

ss.ou <- mcmc.OU.1.1$steppingstone(500000, OUchains, Bk, burnin=0.3, plot=T)
ss.ou <- set.burnin(ss.ou, 0.3)
oulik<-ss.ou$lnr

ss.ou.alphaweighted <- mcmc.OU.2.1$steppingstone(500000, OUchains.alpha.weighted, Bk, burnin=0.3, plot=T)
ss.ou.alphaweighted <- set.burnin(ss.ou.alphaweighted, 0.3)
oualphaweightedlik<-ss.ou.alphaweighted$lnr

ss.bm <- mcmc.BM.1$steppingstone(500000, BMchains, Bk, burnin=0.3, plot=T)
ss.bm <- set.burnin(ss.ou, 0.3)
bmlik<-ss.bm$lnr

